/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.server;

import filenet.vw.api.VWException;
import filenet.vw.base.PunycodeUtils;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;

public class ConfigUtils {
    private static final String m_className = "ConfigUtils";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static VWException getHttpServerError(Exception e, HttpURLConnection conn) {
        VWException vWException;
        BufferedReader data;
        block14: {
            String line;
            InputStream errStream;
            block12: {
                VWException vWException2;
                block13: {
                    VWException ex;
                    data = null;
                    String m_method = "getHttpServerError";
                    InputStream inputStream = errStream = conn == null ? null : conn.getErrorStream();
                    if (errStream != null) break block12;
                    vWException2 = ex = new VWException(e);
                    Object var10_9 = null;
                    if (data == null) break block13;
                    try {
                        data.close();
                    }
                    catch (Exception exx2) {
                        // empty catch block
                    }
                }
                return vWException2;
            }
            StringBuffer buf = new StringBuffer();
            data = new BufferedReader(new InputStreamReader(errStream, Charset.forName("UTF-8")));
            while ((line = data.readLine()) != null) {
                buf.append(line);
            }
            line = buf.toString();
            Exception exx = new Exception(line, e);
            vWException = new VWException(exx);
            Object var10_10 = null;
            if (data == null) break block14;
            try {
                data.close();
            }
            catch (Exception exx2) {
                // empty catch block
            }
        }
        return vWException;
        {
            catch (Exception ex) {
                VWException vWException3;
                block15: {
                    try {
                        vWException3 = new VWException(ex);
                        Object var10_11 = null;
                        if (data == null) break block15;
                    }
                    catch (Throwable throwable) {
                        block16: {
                            Object var10_12 = null;
                            if (data == null) break block16;
                            try {
                                data.close();
                            }
                            catch (Exception exx2) {}
                        }
                        throw throwable;
                    }
                    try {
                        data.close();
                    }
                    catch (Exception exx2) {
                        // empty catch block
                    }
                }
                return vWException3;
            }
        }
    }

    public static String _get_FILE_DATE() {
        return "$Date:   15 Apr 2008 23:01:40  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.21  $";
    }

    protected static void httpGet(String url, int nthreads, boolean verbose) throws VWException {
        try {
            int i;
            Thread[] threads = new Thread[nthreads];
            for (i = 0; i < nthreads; ++i) {
                threads[i] = new Thread(new GetURL(url, i, verbose));
            }
            for (i = 0; i < nthreads; ++i) {
                threads[i].start();
            }
            for (i = 0; i < nthreads; ++i) {
                threads[i].join();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void httpGetSerially(String url, int nthreads, boolean verbose) throws VWException {
        try {
            for (int i = 0; i < nthreads; ++i) {
                new GetURL(url, i, verbose).run();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void printUsage() {
        System.out.println("/url <URL> [/nthreads=# /verbose /parallel]");
        System.out.println("For example:\njava -cp pe.jar;pe3pt.jar;peResources.jar filenet.vw.server.ConfigUtils /url http://localhost:32776/IOR/ping\n");
        System.out.println("List of URL paths:");
        System.out.println("http://PEServer:PENSPort/IOR/ping");
        System.out.println("http://PEServer:PENSPort/IOR/ping?java_dump=true");
        System.out.println("http://PEServer:PENSPort/IOR/FileNet.PE.vworbbroker");
        System.out.println("http://PEServer:PENSPort/IOR/FileNet.PE.PEServerComm");
        System.exit(1);
    }

    public static void main(String[] args) {
        try {
            VWCommandLineArgs c = new VWCommandLineArgs(args);
            if (c.isPresent("h")) {
                ConfigUtils.printUsage();
            }
            boolean verbose = c.isPresent("verbose");
            verbose = true;
            boolean parallel = c.isPresent("parallel");
            String url = c.getParameter("url");
            url = PunycodeUtils.toASCIIURL(url);
            System.out.println("New URL = " + url);
            int nThreads = c.getIntParameter("nthreads", 1);
            if (url != null) {
                if (parallel) {
                    ConfigUtils.httpGet(url, nThreads, verbose);
                } else {
                    ConfigUtils.httpGetSerially(url, nThreads, verbose);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected static class GetURL
    implements Runnable {
        String url;
        int instance;
        boolean verbose = false;

        public GetURL(String url, int instance, boolean verbose) {
            this.url = url;
            this.instance = instance;
            this.verbose = verbose;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block10: {
                buf = new StringBuffer();
                buf.append("\n----------------------------------\nGetURL[").append(this.instance).append("], ").append(this.url).append(":\n");
                conn = null;
                data = null;
                try {
                    try {
                        theURL = new URL(this.url);
                        conn = (HttpURLConnection)theURL.openConnection();
                        conn.connect();
                        data = new BufferedReader(new InputStreamReader(conn.getInputStream(), Charset.forName("UTF-8")));
                        while ((line = data.readLine()) != null) {
                            if (!this.verbose) continue;
                            buf.append("\n").append(line);
                        }
                        var7_8 = null;
                        if (data == null) break block10;
                    }
                    catch (Exception ioEx) {
                        ex = ConfigUtils.getHttpServerError(ioEx, conn);
                        ex.printStackTrace();
                        buf.append(VWException.DescribeThrowableCompletely(ioEx));
                        var7_9 = null;
                        if (data != null) {
                            try {
                                data.close();
                            }
                            catch (Exception e) {}
                        }
                        break block10;
                    }
                }
                catch (Throwable var6_14) {
                    var7_10 = null;
                    if (data == null) throw var6_14;
                    ** try [egrp 2[TRYBLOCK] [4 : 176->183)] { 
lbl38:
                    // 1 sources

                    data.close();
                    throw var6_14;
lbl40:
                    // 1 sources

                    catch (Exception e) {
                        // empty catch block
                    }
                    throw var6_14;
                }
                try {}
                catch (Exception e) {}
                data.close();
            }
            buf.append("\n-----------------------------\n");
            System.out.println(buf.toString());
        }
    }
}

